<?php
session_start();
require_once '../config.php';

// Check if user is logged in
if(!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Unauthorized access']);
    exit;
}

// Get search parameters
$name = isset($_GET['name']) ? trim($_GET['name']) : '';
$domain = isset($_GET['domain']) ? trim($_GET['domain']) : '';
$value = isset($_GET['value']) ? trim($_GET['value']) : '';
$secure = isset($_GET['secure']) ? (int)$_GET['secure'] : 0;
$httponly = isset($_GET['httponly']) ? (int)$_GET['httponly'] : 0;

// Build query
$query = "SELECT cd.*, cl.id as log_id FROM cookie_data cd 
          JOIN cookie_logs cl ON cd.log_id = cl.id 
          WHERE 1=1";
$params = [];
$types = "";

if (!empty($name)) {
    $query .= " AND cd.name LIKE ?";
    $params[] = "%$name%";
    $types .= "s";
}

if (!empty($domain)) {
    $query .= " AND cd.domain LIKE ?";
    $params[] = "%$domain%";
    $types .= "s";
}

if (!empty($value)) {
    $query .= " AND cd.value LIKE ?";
    $params[] = "%$value%";
    $types .= "s";
}

if ($secure) {
    $query .= " AND cd.secure = 1";
}

if ($httponly) {
    $query .= " AND cd.httponly = 1";
}

$query .= " ORDER BY cd.id DESC LIMIT 100";

// Execute query
$stmt = $conn->prepare($query);

if (!empty($types)) {
    $stmt->bind_param($types, ...$params);
}

$stmt->execute();
$result = $stmt->get_result();
$cookies = [];

while ($row = $result->fetch_assoc()) {
    $cookies[] = $row;
}

// Return results
header('Content-Type: application/json');
echo json_encode(['success' => true, 'data' => $cookies]);
exit;
